VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   11250
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   12165
   LinkTopic       =   "Form1"
   ScaleHeight     =   11250
   ScaleWidth      =   12165
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkLandscape 
      Caption         =   "Landscape"
      Height          =   285
      Left            =   3000
      TabIndex        =   3
      Top             =   120
      Width           =   1785
   End
   Begin VB.CommandButton cmdRenderAndShowPDF 
      Caption         =   "Render and show PDF"
      Height          =   345
      Left            =   4890
      TabIndex        =   2
      Top             =   90
      Width           =   2445
   End
   Begin VB.ComboBox cmbPageFormat 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   90
      List            =   "fCairoDemo.frx":000A
      Style           =   2  'Dropdown-Liste
      TabIndex        =   1
      Top             =   90
      Width           =   2805
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   30
      TabIndex        =   0
      Top             =   480
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Enum PageFormatEnm
  PageFormatA4
  PageFormatUSLetter
End Enum

Private PagePreview As cPagePreview

Private CurPageFormat As PageFormatEnm, CurLandscapeInfo As Boolean
Private CurPageWidthPoints As Long, CurPageHeightPoints As Long

Private TableData As Variant 'used within the Page-Drawing, as a small table- and chart-datasource

Private Sub Form_Load()
  Caption = "Resize Me!"
  Me.ScaleMode = vbPixels

  Set PagePreview = New cPagePreview 'we use a small Helper-Object here, which hosts a separate PixelSurface (and helps a bit with the Coord- and Scale-Adaptions)
  Form_Resize
  cmbPageFormat.ListIndex = 0
End Sub

Private Sub Form_Resize()
  'since our PagePreview-Drawing takes place within a separate Surface (mPixelSurface, defined within cPagePreview),
  'we will readjust its size accordingly, so that it fits into the ucCanvas-Dimensions (centered) - *and*
  'also respects the Aspect-Ratio of our currently selected PageSize
  PagePreview.SetPixelSurfaceDimensions ScaleWidth, ScaleHeight - ucCanvas1.Top
  
  'the line below is the normal ucCanvas-Resize-Line as in all the other Demos
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Unload fPDFViewer
End Sub


'------- the different "Control-Changed"-Events ----------
Private Sub cmbPageFormat_Click()
  CurPageFormat = cmbPageFormat.ListIndex
  UpdateCurPageInfos CurPageFormat, CurLandscapeInfo, CurPageWidthPoints, CurPageHeightPoints
  PagePreview.SetPageDimensions CurPageWidthPoints, CurPageHeightPoints
  
  Draw ucCanvas1.CC
  If fPDFViewer.Visible Then cmdRenderAndShowPDF_Click 'in case the PDF-Preview-Window is shown, update that as well
End Sub
Private Sub chkLandscape_Click()
  CurLandscapeInfo = (chkLandscape.Value = 1)
  UpdateCurPageInfos CurPageFormat, CurLandscapeInfo, CurPageWidthPoints, CurPageHeightPoints
  PagePreview.SetPageDimensions CurPageWidthPoints, CurPageHeightPoints
  
  Draw ucCanvas1.CC
End Sub

Private Sub cmdRenderAndShowPDF_Click()
Dim FileName As String, RSuccess As Boolean
  FileName = App.Path & "\test.pdf"
  
  fPDFViewer.RemovePDF 'ensure, that the current File (potentially shown in the Viewer), is released there
  
  RSuccess = RenderPDFDocument(FileName, CurPageFormat) 'now render PDF-content into the given FileName (needs write-access within the App-Path, this Demo runs from)
  
  If RSuccess Then fPDFViewer.LoadPDF FileName 'and finally visualize the just created PDF-content, directly from the just created File
End Sub
'------------- End of "Control-Changed"-Event-Handling ------------------


Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
  'Not that much to do here in the normal ucCanvas.CC-Refresh-Routine as in the other Demos,
  'since all the Page-Rendering takes place in the modPageDrawings.DrawPage routine
  
  'the following two lines ensure (as always) a complete Surface-Fill - ensureing the darker Background-Color this time
  CC.SetSourceColor &HA0A0A0
  CC.Paint

  'here we fill up our small TableData-Array, to be able to provide the Table-Rendering-SubRoutine as
  'well as the Chart-Rendering-Subroutine some "random Input"
  Randomize
  Dim i&, j&
  ReDim TableData(0 To 6, 0 To 4)
  For i = 0 To UBound(TableData, 1)
    For j = 0 To UBound(TableData, 2)
      If i = 0 Then 'write the Header-Cells
        If j = 0 Then TableData(i, j) = "Year" Else TableData(i, j) = "Quarter" & j
      Else 'write the Data-Cells
        If j = 0 Then TableData(i, j) = 2003 + i Else TableData(i, j) = Round(8 + Rnd * 7, 2)
      End If
    Next j
  Next i
  
  With PagePreview 'the PagePreview-Class (which is defined within this Form-Module) is merely responsible for Dimension-Handling and as host of our separated Page-Preview-Surface
    modPageDrawings.DrawPage .PixelCC, TableData 'this is the DrawPage-Routine which is used for the screen-preview-rendering here, but also in the PDF-creation routine
  
    'and (back from 'DrawPage') this only renders the just created content (within our separate Page-Surface) to our usual ucCanvas.CC (onto the darker Background)
    CC.RenderSurfaceContent .PixelSurface, .SrfOffsX, .SrfOffsY, .SrfWidth, .SrfHeight
  End With
  
  ucCanvas1.Refresh
End Sub

'a small Helper-Sub, which mainly reacts to the changes in the PageFormat-combo and the Landscape-Checkbox, updating the passed ByRef-Variables accordingly
Private Sub UpdateCurPageInfos(ByVal PageFormat As PageFormatEnm, ByVal Landscape As Boolean, PageWidthPoints As Long, PageHeightPoints As Long)
Dim Tmp As Long
Const MM2InchFac# = 1 / 25.4

  'The cairo-PDF-PageSize-units are in Points (and one single "Point-unit" is 1/72 inch),
  'so we calculate the ByRef passed size-variables here, according to our currently given PageFormatEnum- and Landscape-Parameters
  Select Case PageFormat
    Case PageFormatA4
      PageWidthPoints = (210 * MM2InchFac) * 72
      PageHeightPoints = (297 * MM2InchFac) * 72
    Case PageFormatUSLetter
      PageWidthPoints = 8.5 * 72
      PageHeightPoints = 11 * 72
  End Select
  
  If Landscape Then 'we just swap the Width and Height
    Tmp = PageWidthPoints
    PageWidthPoints = PageHeightPoints
    PageHeightPoints = Tmp
  End If
End Sub

'this will create a *Two*-page-PDF, respecting the currently selected PageFormat (A4 or alternatively US-Letter)
'the current Landscape-CheckBox-setting is ignored here, since we will draw each page in different a orientation anyways
'The first page in the PDF is created "normally", second page is created Landscape,
'just to show how such a "Mix" within a MultiPage-Document can be accomplished...
Private Function RenderPDFDocument(FileName As String, ByVal PageFormat As PageFormatEnm) As Boolean
Dim PDFSrf As cCairoSurface, PageWidthPoints As Long, PageHeightPoints As Long
  
  'calculate our internal PageWidth/-Height-Variables, according to the PageFormat (non-Landscape first)
  UpdateCurPageInfos PageFormat, False, PageWidthPoints, PageHeightPoints '<- the last 2 params are updated "ByRef"
  'Now we can create a PDF-surface (already containing page 1) -
  Set PDFSrf = Cairo.CreateSurface(PageWidthPoints, PageHeightPoints, PDFSurface)
  
  'now "easy drawing" against the PDF-Surface - the very same routine as for the
  'Screen-Drawings is used, just by passing our PDF-Surfaces Context to it (instead of the "PixelContext", which is hosted in cPagePreview)
  modPageDrawings.DrawPage PDFSrf.CreateContext, TableData

  
  '...drawing of the first page is finished...
  '...and again we call our Helper-Sub, to calculate our internal PageWidth/-Height-Variables, according to the PageFormat, but for Landscape now
  UpdateCurPageInfos PageFormat, True, PageWidthPoints, PageHeightPoints
  'now we will emit the current page in the next line *but* already (re)define
  'the page-dimensions (now oriented in LandScape) for the (thereby automatically created) next page in the PDF-File
  PDFSrf.EmitPDFPage False, PageWidthPoints, PageHeightPoints
  
  'now we draw our things again on the just created "LandScape-oriented" Page - the Drawing-Routine is capable to react to the different orientations in itself
  modPageDrawings.DrawPage PDFSrf.CreateContext, TableData
  
  'Drawing of the Landscape-Page is finished, so let's emit this second, final page too
  PDFSrf.EmitPDFPage '<- by omitting any Parameters here, we ensure, to *not* create any new page furthermore
  
  
  'Ok, we're done with our simple two-page PDF-document...
  'The following finalizes all pages, working somewhat like a "DocumentComplete"
  '(the PDFSrf-object is not usable anymore once this final operation was called)
  'alternatively use (e.g. if you've created such a PDF on a WebServer and want to send it back per sockets+http):
'     Dim B() As Byte
'     PDFSrf.WriteContentToPDFByteArray B
  
  On Error Resume Next 'to determine, if the file is eventually just "locked" by some external PDF-Viewer
    PDFSrf.WriteContentToPDFFile App.Path & "\test.pdf"
  If Err.Number = 70 Then
    Err.Clear
    MsgBox "File is currently locked, or Destination not writable!"
    Exit Function
  End If
  RenderPDFDocument = True
End Function
